<?php
/**
 * This file is used to generate the "Options" page in the admin.
 *
 * @package live-news
 */

if ( ! current_user_can( 'manage_options' ) ) {
	wp_die( esc_html__( 'You do not have sufficient capabilities to access this page.', 'daln' ) );
}

// Sanitization ------------------------------------------------------------------------------------------------------ .
$data['settings_updated'] = isset( $_GET['settings-updated'] ) ? sanitize_key( $_GET['settings-updated'], 10 ) : null;
$data['active_tab']       = isset( $_GET['tab'] ) ? sanitize_key( $_GET['tab'] ) : 'style_options';

?>

<div class="wrap">

	<h2><?php esc_html_e( 'Live News - Options', 'daln' ); ?></h2>

	<?php

	// Settings errors.
	if ( 'true' === $data['settings_updated'] ) {

		settings_errors();
	}

	?>

	<div id="daext-options-wrapper">

		<?php

		// Get current tab value.
		$active_tab = isset( $_GET['tab'] ) ? $_GET['tab'] : 'general';

		?>

		<div class="nav-tab-wrapper">
			<a href="?page=daln-options&tab=general"
				class="nav-tab <?php echo 'general' === $data['active_tab'] ? 'nav-tab-active' : ''; ?>"><?php esc_html_e( 'General', 'daln' ); ?></a>
		</div>

		<form method='post' action='options.php'>

			<?php

			if ( 'general' === $active_tab ) {

				settings_fields( $this->shared->get( 'slug' ) . '_general_options' );
				do_settings_sections( $this->shared->get( 'slug' ) . '_general_options' );

			}

			?>

			<div class="daext-options-action">
				<input type="submit" name="submit" id="submit" class="button"
						value="<?php esc_attr_e( 'Save Changes', 'daln' ); ?>">
			</div>

		</form>

	</div>

</div>